<?php
/**
 * Plugin Name: TrustArc
 * Plugin URI: http://www.trustarc.com/
 * Version: 1.0.0
 * Author: TrustArc, Llc
 * Author URI: https://www.trustarc.com
 * Description: Integrates the TrustArc Cookie Consent Management Platform (CMP) with Joomla, allowing you to easily inject the CMP script, display a cookie banner, and provide a link to the cookie preferences center.
 * License: GPL2
 *
 * @package TrustArc
 */

/**
 * TrustArc
 */
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Utility\JSON;

class PlgSystemTrustArc extends \Joomla\CMS\Plugin\CMSPlugin  
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
    }

    public function onAfterInitialise()
    {
        $app = Factory::getApplication();

        if ($app->isClient('administrator')) {
            return;
        }

        $document = Factory::getDocument();

        // CMP Script
        $cmpVersion = $this->params->get('cmp_version', 'advanced');
        $cmpScript = $this->params->get('cmp_script');
        $cmpScriptParams = $this->params->get('cmp_script_params');

        if ($cmpScript) {
            $hostname = 'https://consent.trustarc.com';
            if ($cmpVersion == 'advanced') {
                $separator = '';
                if (!empty($cmpScriptParams)) {
                    if (strpos($cmpScriptParams, '&') !== 0) {  // Check if & is the first char
                        $separator = '&';
                    }
                }
                $scriptUrl = $hostname . "/notice?domain=" . $cmpScript . $separator . $cmpScriptParams;
            } else { // Pro version
                $separator = '';
                if (!empty($cmpScriptParams)) {
                    if (strpos($cmpScriptParams, '?') !== 0) { // Check if ? is the first char
                        $separator = '?';
                    }
                }
    
                $scriptUrl = $hostname . "/v2/notice/" . $cmpScript . $separator . $cmpScriptParams;
            }
            $document->addScript($scriptUrl, ['type' => 'text/javascript'], ['defer' => true]);
        }

        // Banner Container
        $cmpBanner = $this->params->get('cmp_banner', 'consent_blackbar'); // Default ID

        if ($cmpBanner) {
            $js = "
                document.addEventListener('DOMContentLoaded', function() {
                    var parentElement = document.body;
                    var bannerDiv = document.createElement('div');
                    bannerDiv.id = '$cmpBanner';
                    parentElement.appendChild(bannerDiv);
                });
            ";
            $document->addScriptDeclaration($js, 'text/javascript');
        }

        
        // Preferences Link
        $cmpPreferences = $this->params->get('cmp_preferences', 0);
        $cmpPreferencesSelector = $this->params->get('cmp_preferences_selector');
        if ($cmpPreferences) {
            $js = "
                document.addEventListener('DOMContentLoaded', function() {
                    var body = document.body;
                    if (body) {
                        var bannerDiv = document.createElement('div');
                        bannerDiv.id = '$cmpBanner';
                        body.insertBefore(bannerDiv, body.firstChild);
                    }
                });
            ";
            $document->addScriptDeclaration($js, 'text/javascript');
        }

        $this->injectIntegrations();

    }

    private function injectIntegrations()
    {
        $cmp_google_consent_mode = $this->params->get('cmp_google_consent_mode', 0);
        $cmp_standard_event_listener = $this->params->get('cmp_standard_event_listener', 0);
    
        if (!$cmp_google_consent_mode || !$cmp_standard_event_listener) {
            return;
        }
    
        $cmpGcmEnabled = false;
        $gaMeasurementIdInjection = "";
        $google_consent_fields_json = "";
        $wait_for_update = "";
        $data_redaction_injection = "";
        $url_passthrough_injection = "";
        $cmp_implied_location = "";
        $wpConsentApiMappingJson = "";

        if ($cmp_google_consent_mode) {
            $cmpGcmEnabled = true;

            // Get the individual fields from the params
            $google_consent_fields = $this->params->get('google_consent_fields');
            $googleConsentFields = [];
            $googleConsentFields['ad_storage'] = $google_consent_fields->ad_storage;
            $googleConsentFields['ad_user_data'] = $google_consent_fields->ad_user_data;
            $googleConsentFields['ad_personalization'] = $google_consent_fields->ad_personalization;
            $googleConsentFields['analytics_storage'] = $google_consent_fields->analytics_storage;
            $googleConsentFields['functionality_storage'] = $google_consent_fields->functionality_storage;
            $googleConsentFields['personalization_storage'] = $google_consent_fields->personalization_storage;
            $googleConsentFields['security_storage'] = $google_consent_fields->security_storage;

            $wait_for_update = htmlspecialchars($google_consent_fields->wait_for_update, ENT_QUOTES, 'UTF-8'); // Get the wait_for_update field separately
            
            // GA Measurement ID
            $ga_measurement_id_injection = $this->params->get('cmp_ga_measurement_id', '');
            if (!empty($ga_measurement_id_injection)) {
                $gaMeasurementIdInjection = htmlspecialchars($ga_measurement_id_injection, ENT_QUOTES, 'UTF-8');
            }

            // Data Redaction and URL Passthrough
            $data_redaction_injection = (int) $this->params->get('cmp_ads_data_redaction', 0);
            $url_passthrough_injection = (int) $this->params->get('cmp_url_passthrough', 0);
            $cmp_implied_location = htmlspecialchars($this->params->get('cmp_implied_location', ''), ENT_QUOTES, 'UTF-8');

            // Encode the googleConsentFields array into JSON
            $google_consent_fields_json = json_encode($googleConsentFields, JSON_NUMERIC_CHECK);
        }
    
        // Load JavaScript Integration
        $document = Factory::getDocument();
        $jsFilePath = dirname(__FILE__) . '/include/cmp-integration.inc.php';
        if (file_exists($jsFilePath) && ($cmp_google_consent_mode || $$cmp_standard_event_listener)) {
            ob_start();
            include $jsFilePath;
            $jsContent = ob_get_clean();
            $document->addScriptDeclaration($jsContent, 'text/javascript');
        } elseif (!file_exists($jsFilePath)) {
            Factory::getApplication()->enqueueMessage('cmp-integration.js file not found!', 'warning');
        }
    }    
}
