const domain = window.location.host;


<?php if($cmp_google_consent_mode) { ?>
    /* 
    GOOGLE CONSENT MODE INTEGRATION
    */
    window.dataLayer = window.dataLayer || [];
    function gtag() { dataLayer.push(arguments); }

    gtag('js', new Date());
    gtag('set', 'developer_id.dNTIxZG', true);

    
    <?php if(!empty($ga_measurement_id_injection)) { ?>
gtag('config', '<?php echo $ga_measurement_id_injection; ?>');
    <?php } ?>

    gtag('set', 'ads_data_redaction', <?php echo ($data_redaction_injection == true) ? 'true': 'false'; ?>);

    gtag('set', 'url_passthrough', <?php echo ($url_passthrough_injection == true) ? 'true': 'false'; ?>);

    // Consent Mode Status
    const ConsentType = {
        DENIED: 'denied',
        GRANTED: 'granted',
    };

    const booleanToConsentStatus = (boolean) => boolean ? ConsentType.GRANTED : ConsentType.DENIED;

    /*
    This is where you can configure the Google Consent Mode, map the CMP categorisation and the default values for the consent initialization
    Google recommends commenting our consent types that you are not going to use.
    */
    // Bucket Mapping
    const consentTypesMapped =  <?php echo $google_consent_fields_json; ?>;

    const getConsentState = (prefCookie) => {
        var consentStates = {};

        var noticeBehavior = window.truste.util.readCookie('notice_behavior');

        var impliedLocation = noticeBehavior && noticeBehavior.includes('<?php echo $cmp_implied_location; ?>');

        for (const consentType in consentTypesMapped) {
            var id = consentTypesMapped[consentType];

            if (prefCookie && !prefCookie.includes(0)) {
                consentStates[consentType] = booleanToConsentStatus(prefCookie && prefCookie.includes(id));
            } else {
                consentStates[consentType] = booleanToConsentStatus(impliedLocation);
            }
        }

        consentStates['wait_for_update'] = <?php echo $wait_for_update; ?>;
        return consentStates;
    };

    /*
        Helper function to submit a GCM event based on user's preferences on TrustArc's Script
        consent: The consent object will be an array of values [1, 2, 3, n] as 1 being if the user
                    consented to required, 2 to function, ... etc
        This function needs to be customized according to the customer's needed mapping.
        Ex: 'ad_storage': returnGrantedOrDenied(advertisingAccepted) is being mapped to advertising.
            if we were to map it to functional instead, we just need to change the bucket variable it's looking at.
    */
    var runOnceGCM = 0;
    function handleConsentDecisionForGCM(consent) {

        //This code initializes the consent mode
        const consentStates = getConsentState(consent.consentDecision);
        var defaultOrUpdate;
        if (runOnceGCM == 0) {
            defaultOrUpdate = 'default';
            runOnceGCM++;
        } else {
            defaultOrUpdate = 'update';
        }

        //Once consent is changed, we will send an update
        gtag('consent', defaultOrUpdate, consentStates);
    }

    /*
    This verification will check if tags are firing before default consent is defined.
    */
    var _taInterval;
    var _taAttempts = 0;
    var _taGoogleTagWasSetLate = function () {

        if (_taAttempts > 50)
            clearInterval(_taInterval);

        if (window.google_tag_data && window.google_tag_data.ics && window.google_tag_data.ics.wasSetLate) {
            console.warn('WARNING: Tags are firing before consent is initialized. Please ensure that the consent mode default is initialized before firing tags.');
            clearInterval(_taInterval);
        }

        _taAttempts++;
    }
    _taInterval = setInterval(_taGoogleTagWasSetLate, 200);
    /*
    END OF VERIFICATION
    */
<?php } ?>

/* 
    Event Listener
*/
// This code is responsible for listening to any consent changes trough TrustArc's CCM Instance
// And pushing the consent changes to the dataLayer according to the customer's consent mapping
// This is for the intial load. If the user has a consent different from the default values, this is to push an update to the datalayer
// Once the CCM loads.
var __dispatched__ = {}; //Map of previously dispatched preference levels

function handleConsentDecisionForTA(consent){

    consent.consentDecision && consent.consentDecision.forEach(function(label) {
        if (!__dispatched__[label]) {
            self.dataLayer && self.dataLayer.push({
                "event": "GDPR Pref Allows " + label
            });
            __dispatched__[label] = 1;
        }
    });

}
var interval = setInterval(() => {
    if (window.truste && truste.cma && truste.cma.callApi) {
        var consentDecision = truste.cma.callApi('getGDPRConsentDecision', domain);
        <?php if($cmp_google_consent_mode) { ?>
            handleConsentDecisionForGCM(consentDecision);
        <?php } ?>
        <?php if($cmp_standard_event_listener) { ?>
            handleConsentDecisionForTA(consentDecision);
        <?php } ?>
            
        clearInterval(interval);
    }
}, 100);


// Start listening to when users submit their preferences
window.addEventListener('message', (event) => {
    let eventDataJson = null;
    // We only care about TrustArc Events at this point. And TrustArc's even it encoded in JSON
    try {
        eventDataJson = JSON.parse(event.data);
    } catch {
        // Some other event that is not JSON.
        // TrustArc encodes the data as JSON
    }

    // Safeguard to make sure we are only getting events from TrustArc
    if (eventDataJson && eventDataJson.source === 'preference_manager') {
        // Means that the user has submited their preferences
        if (eventDataJson.message === 'submit_preferences') {
            // Waiting half a second to make sure user's preferences are reflected.
            setTimeout(() => {
                var consentDecision = truste.cma.callApi('getGDPRConsentDecision', domain);

                <?php if($cmp_google_consent_mode) { ?>
                    handleConsentDecisionForGCM(consentDecision);
                <?php } ?>
                <?php if($cmp_standard_event_listener) { ?>
                    handleConsentDecisionForTA(consentDecision);
                <?php } ?>
            }, 500);
        }
    }
}, false);
